import { OData } from "..";
import { SkillTypeCustom, WebApiSkill } from "./custom";
import { EntityRecognitionSkill, KeyPhraseExtractionSkill, LanguageDetectionSkill, MergeSkill, NamedEntityRecognitionSkill, SentimentSkill, SkillTypeText, SplitSkill } from "./text";
import { ShaperSkill, SkillTypeUtil } from "./util";
import { ImageAnalysisSkill, OcrSkill, SkillTypeVision } from "./vision";
export * from './custom';
export * from './text';
export * from './util';
export * from './vision';
export declare type SkillType = SkillTypeText | SkillTypeVision | SkillTypeUtil | SkillTypeCustom;
export declare type Skill = EntityRecognitionSkill | KeyPhraseExtractionSkill | LanguageDetectionSkill | MergeSkill | NamedEntityRecognitionSkill | SentimentSkill | SplitSkill | ImageAnalysisSkill | OcrSkill | WebApiSkill | ShaperSkill;
export interface SkillSet {
    name: string;
    description?: string;
    skills: Skill[];
}
export interface SkillInput<T = string> {
    name: T;
    source: string;
}
export interface SkillOutput<T = string> {
    name: T;
    targetName: string;
}
export interface SkillBase<T extends SkillType, TIn = string, TOut = string> extends OData<T> {
    description?: string;
    context?: string;
    inputs: Array<SkillInput<TIn>>;
    outputs: Array<SkillOutput<TOut>>;
}
export interface SkillResults<T = SkillRecordData> {
    values: Array<SkillRecord<T>>;
}
export interface SkillRecord<T = SkillRecordData> {
    recordId: string;
    data: T;
}
export interface SkillRecordData {
    [key: string]: any;
}
